/*
 * Copyright (c) 2019 - 2024 AB Circle Limited. All rights reserved
 */

package com.abc.usbdemo;

import com.abc.terminalfactory.AbCircleCardTerminalUSB;

import javax.smartcardio.CardTerminal;

public class UsbTerminalHelper {

    static String getFirmwareVersion(CardTerminal terminal) {
        if (terminal == null) {
            throw new IllegalArgumentException("Terminal not found");
        }

        if (!(terminal instanceof AbCircleCardTerminalUSB)) {
            throw new IllegalArgumentException("Is not AbCircleCardTerminalBluetooth");
        } else {
            return ((AbCircleCardTerminalUSB) terminal).getFirmwareVersion();
        }
    }

}
